using UnityEngine;
using System.Collections;
using System.Runtime.InteropServices;

namespace hive.adkit.daro
{
	public class AdKitInterstitial
	{
		public AdKitInterstitial(string adUnitId, EventHandlers handler)
		{
			internalInit(adUnitId, handler);
		}

		~AdKitInterstitial() {
			//
		}

		private string adKey = "";
		
	#if UNITY_ANDROID && !UNITY_EDITOR
		
		private string adKitPluginClass = "com.hive.adkit.daro.plugin.AdKitUnityInterstitial";
		private AndroidJavaObject adKitPlugin = null;

		private void internalInit(string adUnitId, EventHandlers handler) {
			AdKitLogger.d("AdKitInterstitial Init "+adUnitId);

			AndroidJavaClass unityPlayer = new AndroidJavaClass("com.unity3d.player.UnityPlayer");
			AndroidJavaObject currentActivity = unityPlayer.GetStatic<AndroidJavaObject>("currentActivity");

			adKitPlugin = new AndroidJavaObject(adKitPluginClass);
			if (adKitPlugin != null) {
				adKey = adUnitId;
				adKitPlugin.Call("initialize", currentActivity, adUnitId);
				AdKitCallbackManager.Instance.RegisterCallbackHandler(adUnitId, handler);
			} else {
				AdKitLogger.e("Failed to create AndroidJavaObject for " + adKitPluginClass);
			}
		}

		public void Load(string adPlacementInfo) {

			if(adKitPlugin == null) {
				AdKitLogger.e("Load() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}
			
			AdKitLogger.d("AdKitInterstitial Load");
			adKitPlugin.Call("load", adPlacementInfo);
			
		}

		public void Show(string adPlacementInfo) {

			if(adKitPlugin == null) {
				AdKitLogger.e("Show() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}
			
			AdKitLogger.d("AdKitInterstitial Show");
			adKitPlugin.Call("show", adPlacementInfo);
		}

		public void Destroy() {

			if(adKitPlugin == null) {
				AdKitLogger.e("Destroy() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return;
			}

			AdKitLogger.d("AdKitInterstitial Destroy");
			adKitPlugin.Call("destroy");
			AdKitCallbackManager.Instance.UnregisterCallbackHandler(adKey);
		}

		public bool IsLoaded() {

			if(adKitPlugin == null) {
				AdKitLogger.e("IsLoaded() Failed to create AndroidJavaObject for " + adKitPluginClass);
				return false;
			}
			
			bool isLoaded = adKitPlugin.Call<bool>("isLoaded");
			return isLoaded;
		}

	#elif UNITY_IOS && !UNITY_EDITOR

		[DllImport("__Internal")]
		private static extern void AdKit_InterstitialInitialize(string adUnitId);

		[DllImport("__Internal")]
		private static extern void AdKit_InterstitialLoad(string adUnitId, string adPlacementInfo);

		[DllImport("__Internal")]
		private static extern void AdKit_InterstitialShow(string adUnitId, string adPlacementInfo);

		[DllImport("__Internal")]
		private static extern void AdKit_InterstitialDestroy(string adUnitId);

		[DllImport("__Internal")]
		private static extern bool AdKit_InterstitialIsLoaded(string adUnitId);

		private void internalInit(string adUnitId, EventHandlers handler) {
			AdKitLogger.d("AdKitInterstitial Init "+adUnitId);
			adKey = adUnitId;
			
			AdKitCallbackManager.Instance.RegisterCallbackHandler(adUnitId, handler);

			AdKit_InterstitialInitialize(adUnitId);
		}

		public void Load(string adPlacementInfo) {
			AdKitLogger.d("AdKitInterstitial Load");
			AdKit_InterstitialLoad(adKey, adPlacementInfo);
		}

		public void Show(string adPlacementInfo) {
			AdKitLogger.d("AdKitInterstitial Show");
			AdKit_InterstitialShow(adKey, adPlacementInfo);
		}

		public void Destroy() {
			AdKitLogger.d("AdKitInterstitial Destroy");
			AdKit_InterstitialDestroy(adKey);
			AdKitCallbackManager.Instance.UnregisterCallbackHandler(adKey);
		}

		public bool IsLoaded() {
			return AdKit_InterstitialIsLoaded(adKey);
		}
	#else

		public void internalInit(string adUnitId, EventHandlers handler) {
			
		}

		public void Load(string adPlacementInfo) {
			
		}		

		public void Show(string adPlacementInfo) {
			
		}

		public void Destroy() {
			
		}
		
		public bool IsLoaded()
		{
			return false;
		}
	#endif
		
	}
}